(function(){
  // Add small toolbar to mark/unmark draggable and save
  const bar=document.createElement('div');
  bar.style.cssText='position:fixed;top:10px;right:10px;z-index:999999;background:#0b1220;color:#fff;padding:8px 10px;border-radius:10px;font:12px system-ui;display:flex;gap:6px;align-items:center';
  bar.innerHTML='<button id="ua_mark" style="border:0;border-radius:8px;padding:6px 10px;background:#2563eb;color:#fff">Mark draggable</button>'+
                '<button id="ua_unmark" style="border:0;border-radius:8px;padding:6px 10px;background:#ef4444;color:#fff">Unmark</button>'+
                '<button id="ua_save" style="border:0;border-radius:8px;padding:6px 10px;background:#22c55e;color:#0b1220">Save page</button>'+
                '<span style="opacity:.8">Shift+Click عنصر لوسمه/إلغاء وAlt لالتقاط والدخول داخل عنصر أصغر</span>';
  document.documentElement.appendChild(bar);

  function hoverBox(){
    const d=document.createElement('div');
    d.style.cssText='position:fixed;z-index:999998;border:2px dashed #22c55e;background:rgba(34,197,94,.08);pointer-events:none;display:none';
    document.documentElement.appendChild(d); return d;
  }
  const hl=hoverBox(); let _target=null;
  function rect(el){ const r=el.getBoundingClientRect(); hl.style.left=r.left+'px'; hl.style.top=r.top+'px'; hl.style.width=r.width+'px'; hl.style.height=r.height+'px'; }
  document.addEventListener('mousemove', (e)=>{ if(!e.target||e.target===document.body||e.target===document.documentElement||bar.contains(e.target)){ hl.style.display='none'; return; } _target=e.target; rect(_target); hl.style.display='block'; }, true);

  function toggleMark(el){
    if(!el || el===document.body || el===document.documentElement) return;
    if(el.closest('html')==null) return;
    if(el.hasAttribute('data-draggable')){ el.removeAttribute('data-draggable'); el.style.outline=''; }
    else { el.setAttribute('data-draggable','1'); el.style.outline='1px dashed #60a5fa'; }
  }

  document.addEventListener('click', function(e){
    if(e.target.id==='ua_mark'||e.target.id==='ua_unmark'||e.target.id==='ua_save') return;
    if(!e.shiftKey && !e.altKey) return;
    e.preventDefault(); e.stopPropagation();
    let el=e.target;
    if(e.altKey){ // try to go deeper
      const c=el.children[0]; if(c) el=c;
    }
    toggleMark(el);
  }, true);

  function makeContainersSortable(){
    // enable Sortable on parents that have marked children
    const parents=new Set();
    document.querySelectorAll('[data-draggable="1"]').forEach(function(child){
      if(child.parentElement) parents.add(child.parentElement);
    });
    parents.forEach(function(p){
      if(p.__ua_sortable) return;
      p.__ua_sortable = new Sortable(p, { animation:150, draggable:'[data-draggable="1"]' });
    });
  }
  makeContainersSortable();

  document.getElementById('ua_mark').addEventListener('click', function(){
    if(_target) toggleMark(_target); makeContainersSortable();
  });
  document.getElementById('ua_unmark').addEventListener('click', function(){
    if(_target && _target.hasAttribute('data-draggable')) toggleMark(_target);
  });
  document.getElementById('ua_save').addEventListener('click', function(){
    try{
      const html='<!doctype html>\n'+document.documentElement.outerHTML;
      window.parent.postMessage({type:'UA_BUILDER_SAVE', html: html}, '*');
    }catch(e){ alert('Save failed: '+e.message); }
  });

})();
