<?php
/* domain_gate.php (Server A)
 * بروكسي داخلي: يأخذ __path (اختياري) أو أول صفحة من settings.json
 * يُرجع الصفحة كما هي (بدون حقن). B مسؤول عن إعادة كتابة الأصول/الحقن.
 */

$A_BASE = rtrim('https://omk.run.place/go/','/'); // جذر المشروع على A
$SETTINGS_JSON_URL = $A_BASE.'/settings.json';

/* اختر الصفحة */
$req_path = isset($_GET['__path']) ? trim($_GET['__path']) : '';
if ($req_path === '') {
  $ch = curl_init($SETTINGS_JSON_URL);
  curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>true,CURLOPT_FOLLOWLOCATION=>true,CURLOPT_SSL_VERIFYPEER=>false,CURLOPT_SSL_VERIFYHOST=>false]);
  $settings = curl_exec($ch);
  curl_close($ch);
  $page = '';
  if ($settings) {
    $j = json_decode($settings, true);
    if (is_array($j) && !empty($j['pages'][0]['php'])) $page = $j['pages'][0]['php'];
  }
  $req_path = $page ?: 'index.php';
}

/* جهّز URL النهائي */
$q = $_GET; unset($q['__path']);
$qs = http_build_query($q);
$target = $A_BASE.'/'.ltrim($req_path,'/');
$target .= ($qs ? ('?'.$qs) : '');

/* اجلب الصفحة من A نفسها (static/normal) */
$ch = curl_init($target);
$hdrs = [];
foreach (['Accept','Accept-Language','Content-Type','Authorization','Cookie','Referer','Origin','User-Agent'] as $h){
  $k='HTTP_'.strtoupper(str_replace('-','_',$h));
  if (!empty($_SERVER[$k])) $hdrs[] = $h.': '.$_SERVER[$k];
}
curl_setopt_array($ch,[
  CURLOPT_RETURNTRANSFER=>true, CURLOPT_FOLLOWLOCATION=>true,
  CURLOPT_HEADER=>true, CURLOPT_HTTPHEADER=>$hdrs,
  CURLOPT_SSL_VERIFYPEER=>false, CURLOPT_SSL_VERIFYHOST=>false,
  CURLOPT_ENCODING=>'',
]);
$resp = curl_exec($ch);
if ($resp===false) { http_response_code(502); exit('Bad gateway'); }
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$pos  = strpos($resp, "\r\n\r\n");
$rawH = ($pos===false)? '' : substr($resp,0,$pos);
$body = ($pos===false)? $resp : substr($resp,$pos+4);

http_response_code($code ?: 200);
$ctype='text/html; charset=utf-8';
foreach (explode("\r\n",$rawH) as $h){
  if (stripos($h,'Content-Type:')===0) { $ctype=trim(substr($h,13)); break; }
}
header('Content-Type: '.$ctype);
echo $body;
