<?php
/************************************************************
 * Admin Panel (Pages + Fields + Per-Form Submit + Telegram)
 ************************************************************/
header('X-Content-Type-Options: nosniff');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // Save settings.json (raw JSON)
  if (isset($_GET['save'])) {
    $raw = file_get_contents('php://input');
    json_decode($raw);
    if (json_last_error() !== JSON_ERROR_NONE) {
      http_response_code(400);
      echo json_encode(['ok'=>0,'err'=>'Invalid JSON']);
      exit;
    }
    if (strlen($raw) > 2*1024*1024) {
      http_response_code(413);
      echo json_encode(['ok'=>0,'err'=>'Payload too large']);
      exit;
    }
    file_put_contents('settings.json', $raw);
    echo json_encode(['ok'=>1]);
    exit;
  }

  // Create a new page
  if (isset($_GET['create_page'])) {
    $settings = file_exists('settings.json') ? json_decode(file_get_contents('settings.json'), true) : [];
    if (!isset($settings['pages'])) $settings['pages'] = [];
    $page_name = preg_replace('/[^A-Za-z0-9_\- ]+/', '', $_POST['display'] ?? '');
    $rand = substr(md5(mt_rand()), 0, 8);
    $filename = "page_{$rand}.php";
    $starter = "<!-- ".htmlspecialchars($page_name, ENT_QUOTES, 'UTF-8')." -->\n";
    file_put_contents($filename, $starter);
    $settings['pages'][] = [
      "display" => $page_name ?: "Page $rand",
      "php" => $filename,
      "forms_order" => [],
      "html" => "",
      "forms_submit" => []
    ];
    file_put_contents('settings.json', json_encode($settings, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
    echo json_encode(['ok'=>1, 'php'=>$filename, 'display'=>$page_name]);
    exit;
  }

  // Save HTML into page_xxxxxxxx.php file
  if (isset($_GET['save_html'])) {
    $filename = basename($_POST['filename'] ?? '');
    $html = $_POST['html'] ?? '';
    if (!preg_match('/^page_[a-z0-9]{8}\.php$/', $filename)) {
      echo json_encode(['ok'=>0,'err'=>'Wrong filename']);
      exit;
    }
    file_put_contents($filename, $html);
    echo json_encode(['ok'=>1]);
    exit;
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Admin Panel — Modern & Colored</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <meta http-equiv="Cache-Control" content="no-store" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">
  <style>
    :root{
      --brand: #0076ff;
      --accent: #ff5c57;
      --green: #22c55e;
      --yellow: #ffca2c;
      --bg: linear-gradient(135deg, #f5faff 0%, #e3f1ff 100%);
      --sidebar-bg: #fff;
      --card-bg: #fff;
      --panel-radius: 20px;
      --shadow: 0 8px 32px rgba(0,0,0,0.09);
      --muted: #6c7a89;
      --ink: #222b45;
      --line: #e7efff;
    }
    body{
      background: var(--bg);
      min-height:100vh;
      font-family: 'Segoe UI', 'Tahoma', 'Geneva', 'Verdana', sans-serif;
      color: var(--ink);
    }
    .colorful-brand{
      background: linear-gradient(90deg, var(--brand), var(--accent));
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      font-weight: 900;
      font-size: 2.4rem;
      letter-spacing:.5px;
      margin-bottom:18px;
    }
    .login-fullscreen{
      position: fixed;
      left: 0; top: 0; width: 100vw; height: 100vh;
      background: var(--bg);
      z-index: 9999;
      display: flex;
      align-items: center;
      justify-content: center;
      transition: .5s;
    }
    .login-card{
      background: var(--card-bg);
      border-radius: var(--panel-radius);
      box-shadow: var(--shadow);
      padding: 46px 38px 38px 38px;
      max-width: 410px;
      width:100%;
      border:1px solid var(--line);
      text-align: center;
      animation: popfade .8s cubic-bezier(.42,2,.58,.5) 1;
    }
    @keyframes popfade{from{opacity:0;transform:scale(.94);}to{opacity:1;transform:scale(1);}}
    .login-card .fa-lock{
      font-size:2.4rem;
      color:var(--brand);
      margin-bottom:16px;
    }
    .login-slogan{
      font-size:1.1rem;
      color:var(--muted);
      margin-bottom:28px;
    }
    .login-card input[type=password]{
      font-size:1.2rem;padding:14px;border-radius:8px;border:1.5px solid var(--line);
      transition:.2s;
    }
    .login-card input[type=password]:focus{border-color:var(--brand);}
    .login-card .btn-primary{
      background: linear-gradient(90deg, var(--brand), var(--accent));
      border: none;
      font-size: 1.2rem;
      padding: 12px 0;
      border-radius: 8px;
      box-shadow:0 2px 16px rgba(0,118,255,.14);
      transition:.2s;
      font-weight:600;
      margin-top:10px;
    }
    .login-msg{
      margin-top:20px;
      font-size:1.1rem;
      color:var(--accent);
      min-height:28px;
      transition:.2s;
    }
    /* Admin Panel general */
    .admin-panel{
      margin:36px auto;
      max-width:1400px;
      transition:.6s;
    }
    .card{
      background: var(--card-bg);
      border-radius: var(--panel-radius);
      box-shadow: var(--shadow);
      border:1px solid var(--line);
    }
    .sidebar{
      min-width: 280px;
      background: var(--sidebar-bg);
      border-radius: var(--panel-radius);
      box-shadow: var(--shadow);
      padding: 24px 18px;
    }
    .sidebar-header{
      font-size:1.2rem;
      font-weight:700;
      color:var(--brand);
      margin-bottom:24px;
      letter-spacing:1px;
    }
    .sidebar .btn-primary{
      background: linear-gradient(90deg, var(--brand), var(--accent));
      border: none;
      font-weight:600;
      font-size:1rem;
    }
    .page-list .list-group-item{
      display:flex;align-items:center;justify-content:space-between;
      background: #f7fbff;
      margin-bottom:8px;
      border-radius:8px;
      border:1px solid #e7efff;
      font-weight:500;
      font-size:1.05rem;
      color:#234;
    }
    .page-list .grip{color:#9aa7bd; cursor:grab}
    .page-list .btn-outline-danger{
      border-radius:50%;
      padding:6px 10px;
      font-size:1rem;
      color:var(--accent);
      border:1.2px solid var(--accent);
      background:#fff;
    }
    .topbar{
      display:flex; align-items:center; justify-content:space-between; gap:16px; padding-bottom:8px;
    }
    .brand-title{
      font-weight:900; font-size:2rem; letter-spacing:1px; color:var(--brand);
    }
    .sticky-actions{position:sticky; top:10px; display:flex; gap:8px;}
    .divider{height:2px; background:var(--line); margin:14px 0}
    .nav-tabs .nav-link.active{
      background: linear-gradient(90deg, var(--brand), var(--accent));
      color:#fff;
      border-radius:8px 8px 0 0;
      font-weight:600;
    }
    .nav-tabs .nav-link{
      font-weight:600;
      font-size:1.07rem;
      color:var(--brand);
    }
    .tab-pane{padding-top:18px;}
    .table thead th{white-space:nowrap}
    .code{font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", monospace;}
    textarea.code{white-space:pre; overflow:auto}
    .mini{font-size:13px; color:var(--muted)}
    .form-label{font-weight:500;color:var(--brand);}
    /* Preview styles (idea from injectCardFields) */
    .preview-wrap{
      background:#f8fbff;border:1px dashed var(--line);border-radius:12px;padding:16px
    }
    .preview-title{font-weight:700;color:#234;margin-bottom:10px}
    .row-fields{display:grid;grid-template-columns:1fr 1fr;gap:12px}
    .card-input{display:flex;flex-direction:column;margin-bottom:12px}
    .card-input.small{margin-bottom:0}
    .card-input__label{font-size:.9rem;color:#334a6b;margin-bottom:6px}
    .card-input__input,.preview-input{
      border:1px solid #dbe7ff;border-radius:8px;padding:10px 12px;outline:none
    }
    .card-input__input:focus,.preview-input:focus{border-color:var(--brand)}
    @media (max-width: 768px){
      .row-fields{grid-template-columns:1fr}
    }
  </style>
</head>
<body>
  <!-- Login Fullscreen -->
  <div id="loginScreen" class="login-fullscreen">
    <div class="login-card">
      <div class="fa fa-lock"></div>
      <div class="colorful-brand">Admin Login</div>
      <div class="login-slogan">Welcome to your colorful admin panel.<br>Enter the password to continue.</div>
      <input id="adminPass" type="password" class="form-control mb-3" placeholder="Password">
      <button class="btn btn-primary w-100" id="btnLogin" type="button"><i class="fa fa-sign-in-alt me-2"></i>Login</button>
      <div class="login-msg" id="loginMsg"></div>
    </div>
  </div>
  <!-- Admin Panel Main -->
  <div class="admin-panel container-fluid" id="adminPanel" style="display:none;">
    <div class="card p-4 mb-4">
      <div class="topbar">
        <div class="brand-title"><i class="fa fa-cogs me-2"></i>Admin Panel</div>
        <div class="d-flex gap-2">
          <button class="btn btn-outline-secondary" id="btnReload"><i class="fa fa-rotate"></i> Reload</button>
          <button class="btn btn-danger" id="btnLogout"><i class="fa fa-sign-out-alt"></i> Logout</button>
        </div>
      </div>
    </div>
    <div class="row g-4">
      <!-- Sidebar: Pages -->
      <div class="col-12 col-lg-4">
        <div class="sidebar">
          <div class="sidebar-header"><i class="fa fa-file-alt me-2"></i>Pages</div>
          <button class="btn btn-primary mb-2 w-100" id="btnCreatePage"><i class="fa fa-plus"></i> Create Page</button>
          <div class="mini mb-2">Drag to reorder. Click to select. Trash to delete.</div>
          <ul id="pagesList" class="list-group page-list"></ul>
        </div>
      </div>
      <!-- Main editor -->
      <div class="col-12 col-lg-8">
        <div class="card p-4">
          <div class="d-flex justify-content-between align-items-center">
            <div>
              <div class="mini">File: <span id="currentFile" class="fw-semibold"></span></div>
              <div class="d-flex gap-2 align-items-center mt-1">
                <label class="mini me-2">Page Title</label>
                <input id="pageTitle" class="form-control form-control-sm" style="max-width:360px">
              </div>
            </div>
            <div class="sticky-actions">
              <button class="btn btn-success" id="btnSaveAll"><i class="fa fa-floppy-disk"></i> Save All</button>
            </div>
          </div>
          <div class="divider"></div>
          <!-- Tabs -->
          <ul class="nav nav-tabs" id="mainTabs" role="tablist">
            <li class="nav-item"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tabFields" type="button" role="tab">Fields</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tabFormsSubmit" type="button" role="tab">Forms Submit</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tabPageHtml" type="button" role="tab">Page HTML</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tabTelegram" type="button" role="tab">Telegram</button></li>
          </ul>
          <div class="tab-content">
            <!-- Fields TAB -->
            <div class="tab-pane fade show active" id="tabFields" role="tabpanel">
              <div class="row g-3 align-items-end">
                <div class="col-md-6">
                  <label class="form-label">Select Form</label>
                  <select id="formsSelect" class="form-select"></select>
                </div>
                <div class="col-md-6 d-flex gap-2">
                  <button class="btn btn-outline-success" id="btnNewForm"><i class="fa fa-plus"></i> New Form</button>
                  <button class="btn btn-outline-secondary" id="btnRenameForm"><i class="fa fa-i-cursor"></i> Rename Form</button>
                  <button class="btn btn-outline-danger" id="btnDeleteForm"><i class="fa fa-trash"></i> Delete Form</button>
                </div>
              </div>

              <div class="row g-3 mt-2">
                <div class="col-lg-7">
                  <div class="table-responsive">
                    <table class="table table-sm align-middle" id="fieldsTable">
                      <thead class="table-light">
                        <tr>
                          <th style="width:26px;"></th>
                          <th>name</th>
                          <th>label</th>
                          <th>type</th>
                          <th>placeholder</th>
                          <th>req</th>
                          <th>pattern</th>
                          <th>min</th>
                          <th>max</th>
                          <th>JS (optional)</th>
                          <th>CSS (optional)</th>
                          <th style="width:46px;"></th>
                        </tr>
                      </thead>
                      <tbody></tbody>
                    </table>
                  </div>
                  <button class="btn btn-primary btn-sm" id="btnAddField"><i class="fa fa-plus"></i> Add Field</button>

                  <div class="divider"></div>

                  <h6>Forms in this Page</h6>
                  <div class="row g-3">
                    <div class="col-md-5">
                      <label class="form-label mini">Available Forms</label>
                      <select id="availableForms" class="form-select" multiple size="8"></select>
                    </div>
                    <div class="col-md-7">
                      <label class="form-label mini">Order in Page</label>
                      <ul id="pageFormsOrder" class="list-group"></ul>
                      <div class="mini mt-2">Drag to reorder. Trash to remove.</div>
                    </div>
                  </div>
                </div>

                <!-- LIVE PREVIEW (idea from injectCardFields) -->
                <div class="col-lg-5">
                  <div class="preview-wrap">
                    <div class="preview-title"><i class="fa fa-eye me-2"></i>Live Preview</div>
                    <form id="previewForm">
                      <div id="formPreview"></div>
                      <button type="button" class="btn btn-outline-primary btn-sm mt-2" id="btnRefreshPreview">
                        <i class="fa fa-rotate me-1"></i>Refresh Preview
                      </button>
                    </form>
                    <div class="mini mt-2">
                      * المعاينة لا تحفظ شيئًا — هي لعرض شكل الحقول فقط (تطبق small/rows و الـ CSS البسيط).
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Forms Submit TAB -->
            <div class="tab-pane fade" id="tabFormsSubmit" role="tabpanel">
              <div id="formsSubmitWrap"></div>
            </div>

            <!-- Page HTML TAB -->
            <div class="tab-pane fade" id="tabPageHtml" role="tabpanel">
              <label class="form-label">HTML content of this page</label>
              <textarea id="pageHtml" class="form-control code" style="min-height:260px"></textarea>
              <div class="mini mt-2">Saving will also write this HTML to the page file shown above.</div>
            </div>

            <!-- Telegram TAB -->
            <div class="tab-pane fade" id="tabTelegram" role="tabpanel">
              <div class="row g-3">
                <div class="col-md-6">
                  <label class="form-label">Bot Token</label>
                  <input id="tgToken" class="form-control">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Chat ID</label>
                  <input id="tgChat" class="form-control">
                </div>
              </div>
              <button class="btn btn-success mt-3" id="btnSaveTelegram">Save Telegram</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- libs -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.2/Sortable.min.js"></script>

  <script>
    /******************** CONFIG ********************/
    const ADMIN_PASSWORD = "0165625092"; // change in production!
    let settings = { pages:[], fields:{}, telegram:{} };
    let currentPageIdx = 0;

    /******************** HELPERS *******************/
    const $ = sel => document.querySelector(sel);
    const $$ = sel => Array.from(document.querySelectorAll(sel));
    function toast(msg, cls='success'){
      const el = document.createElement('div');
      el.className = `position-fixed bottom-0 end-0 m-3 alert alert-${cls}`;
      el.textContent = msg;
      document.body.appendChild(el);
      setTimeout(()=>el.remove(), 1800);
    }
    function escapeHTML(s){
      return (s ?? '').replace(/[&<>"']/g, (m)=>({ '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;' }[m]));
    }
    function cssID(s){return (s??'').replace(/\s+/g,'_').replace(/[^A-Za-z0-9_\-]/g,'_')}

    async function loadSettings(){
      const res = await fetch('settings.json?'+Date.now());
      if(res.ok){
        settings = await res.json();
        settings.pages ??= [];
        settings.fields ??= {};
        settings.telegram ??= {};
      } else {
        settings = { pages:[], fields:{}, telegram:{} };
      }
    }
    async function saveSettings(){
      await fetch('admin.php?save=1', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify(settings)
      });
    }
    async function savePageFile(filename, html){
      await fetch('admin.php?save_html=1', {
        method:'POST',
        headers:{'Content-Type':'application/x-www-form-urlencoded'},
        body:'filename='+encodeURIComponent(filename)+'&html='+encodeURIComponent(html)
      });
    }

    /******************** AUTH **********************/
    function showLogin(){
      $('#loginScreen').style.display = 'flex';
      $('#adminPanel').style.display = 'none';
      $('#adminPass').value = '';
      $('#loginMsg').textContent = '';
    }
    function showEditor(){
      $('#loginScreen').style.display = 'none';
      $('#adminPanel').style.display = 'block';
    }
    function initAuth(){
      if(localStorage.getItem('admin_ok') === '1'){
        showEditor();
        init();
      } else {
        showLogin();
      }
    }
    document.addEventListener('DOMContentLoaded', function() {
      // login
      const btnLogin = $('#btnLogin');
      if(btnLogin){
        btnLogin.onclick = function() {
          const pass = $('#adminPass').value;
          if(pass === ADMIN_PASSWORD) {
            localStorage.setItem('admin_ok', '1');
            showEditor();
            $('#loginMsg').textContent = '';
            if(typeof init === 'function') init();
          } else {
            $('#loginMsg').textContent = 'Incorrect password. Please try again.';
            $('#adminPass').value = '';
          }
        };
      }
      // logout
      const btnLogout = $('#btnLogout');
      if(btnLogout){
        btnLogout.onclick = function() {
          localStorage.removeItem('admin_ok');
          showLogin();
        };
      }
      // Boot
      initAuth();
    });

    /******************** INIT **********************/
    async function init(){
      await loadSettings();
      buildPagesSidebar();
      bindTopBar();
      if(settings.pages.length===0){
        $('#currentFile').textContent = '—';
        $('#pageTitle').value = '';
        fillFormsSelect();
        renderFieldsTable();
        renderFormsOrder();
        renderFormsSubmit();
        $('#pageHtml').value = '';
        $('#tgToken').value = settings.telegram?.bot_token||'';
        $('#tgChat').value = settings.telegram?.chat_id||'';
        renderFormPreview(); // empty
        return;
      }
      renderEditorFor(currentPageIdx);
    }

    /******************** TOP BAR *******************/
    function bindTopBar(){
      $('#btnReload').onclick = async ()=>{ await init(); toast('Reloaded'); };
      $('#btnSaveAll').onclick = saveAll;
      $('#btnSaveTelegram').onclick = async ()=>{
        settings.telegram ??= {};
        settings.telegram.bot_token = $('#tgToken').value.trim();
        settings.telegram.chat_id = $('#tgChat').value.trim();
        await saveSettings();
        toast('Telegram settings saved');
      };
      $('#btnCreatePage').onclick = async ()=>{
        const name = prompt('Enter page name:'); if(!name) return;
        const res = await fetch('admin.php?create_page=1', {
          method:'POST',
          headers:{'Content-Type':'application/x-www-form-urlencoded'},
          body:'display='+encodeURIComponent(name)
        });
        const d = await res.json();
        if(d.ok){
          await loadSettings();
          currentPageIdx = settings.pages.length-1;
          buildPagesSidebar();
          renderEditorFor(currentPageIdx);
          toast('Page created');
        }
      };
      // manual refresh preview
      $('#btnRefreshPreview').onclick = ()=> renderFormPreview($('#formsSelect').value);
    }

    /**************** PAGES SIDEBAR *****************/
    function buildPagesSidebar(){
      const ul = $('#pagesList'); ul.innerHTML = '';
      (settings.pages||[]).forEach((pg,idx)=>{
        const li = document.createElement('li');
        li.className = 'list-group-item';
        li.innerHTML = `
          <div class="name">
            <span class="grip"><i class="fa fa-grip-vertical"></i></span>
            <span>${escapeHTML(pg.display||('Page '+(idx+1)))}</span>
          </div>
          <div class="ops">
            <button class="btn btn-sm btn-outline-danger" title="Delete"><i class="fa fa-trash"></i></button>
          </div>`;
        li.onclick = (e)=>{ if(e.target.closest('.ops')) return; currentPageIdx = idx; renderEditorFor(idx); };
        li.querySelector('.btn-outline-danger').onclick = async (ev)=>{
          ev.stopPropagation();
          if(!confirm('Delete this page?')) return;
          settings.pages.splice(idx,1);
          if(currentPageIdx>=settings.pages.length) currentPageIdx = settings.pages.length-1;
          await saveSettings();
          buildPagesSidebar();
          if(settings.pages.length){ renderEditorFor(Math.max(0,currentPageIdx)); } else init();
          toast('Page deleted','warning');
        };
        ul.appendChild(li);
      });

      new Sortable(ul, {
        handle: '.grip',
        animation: 150,
        onEnd: async (evt)=>{
          if(evt.oldIndex===evt.newIndex) return;
          const moved = settings.pages.splice(evt.oldIndex,1)[0];
          settings.pages.splice(evt.newIndex,0,moved);
          if(currentPageIdx===evt.oldIndex) currentPageIdx = evt.newIndex;
          await saveSettings();
          buildPagesSidebar();
          renderEditorFor(currentPageIdx);
        }
      });
    }

    /**************** MAIN EDITOR *******************/
    function renderEditorFor(idx){
      const pg = settings.pages[idx];
      $('#currentFile').textContent = pg.php;
      $('#pageTitle').value = pg.display||'';
      $('#pageTitle').onchange = async (e)=>{ pg.display = e.target.value.trim(); await saveSettings(); buildPagesSidebar(); };

      fillFormsSelect();
      renderFieldsTable();
      renderFormsOrder();
      renderFormsSubmit();
      $('#pageHtml').value = pg.html||'';
      $('#tgToken').value = settings.telegram?.bot_token||'';
      $('#tgChat').value = settings.telegram?.chat_id||'';

      // Buttons in Fields tab:
      $('#btnNewForm').onclick = async ()=>{
        const fname = prompt('New form name (letters, digits, underscore):','form1');
        if(!fname) return;
        if(settings.fields[fname]){ alert('Form already exists'); return; }
        settings.fields[fname] = [];
        await saveSettings();
        fillFormsSelect(fname);
        renderFieldsTable();
        renderFormsOrder();
        renderFormPreview(fname);
      };
      $('#btnRenameForm').onclick = async ()=>{
        const cur = $('#formsSelect').value;
        if(!cur){ alert('Select a form'); return; }
        const nn = prompt('New form name:', cur);
        if(!nn || nn===cur) return;
        if(settings.fields[nn]){ alert('A form with that name exists'); return; }
        settings.fields[nn] = settings.fields[cur];
        delete settings.fields[cur];
        (settings.pages||[]).forEach(p=>{
          p.forms_order = (p.forms_order||[]).map(x=>x===cur?nn:x);
          if(p.forms_submit && p.forms_submit[cur]){
            p.forms_submit[nn] = p.forms_submit[cur];
            delete p.forms_submit[cur];
          }
        });
        await saveSettings();
        fillFormsSelect(nn);
        renderFieldsTable();
        renderFormsOrder();
        renderFormsSubmit();
        renderFormPreview(nn);
      };
      $('#btnDeleteForm').onclick = async ()=>{
        const cur = $('#formsSelect').value;
        if(!cur){ alert('Select a form'); return; }
        if(!confirm(`Delete form "${cur}" and all its fields?`)) return;
        delete settings.fields[cur];
        (settings.pages||[]).forEach(p=>{
          p.forms_order = (p.forms_order||[]).filter(x=>x!==cur);
          if(p.forms_submit) delete p.forms_submit[cur];
        });
        await saveSettings();
        fillFormsSelect();
        renderFieldsTable();
        renderFormsOrder();
        renderFormsSubmit();
        renderFormPreview(); // cleared
      };
      $('#btnAddField').onclick = async ()=>{
        const cur = $('#formsSelect').value;
        if(!cur){ alert('Select a form'); return; }
        settings.fields[cur] = settings.fields[cur]||[];
        settings.fields[cur].push({name:'',label:'',type:'text',placeholder:'',required:false,pattern:'',min:'',max:'',js:'',css:'', small:false});
        await saveSettings();
        renderFieldsTable();
        renderFormPreview(cur);
      };

      // أول ما ندخل صفحة – اعرض معاينة للفورم الحالي (لو موجود)
      renderFormPreview($('#formsSelect').value);
    }

    function fillFormsSelect(selectValue){
      const sel = $('#formsSelect');
      const forms = Object.keys(settings.fields||{});
      sel.innerHTML = forms.map(f=>`<option value="${escapeHTML(f)}"${f===selectValue?' selected':''}>${escapeHTML(f)}</option>`).join('');
      sel.onchange = ()=>{
        renderFieldsTable();
        renderFormPreview(sel.value);
      };
    }

    function renderFieldsTable(){
      const cur = $('#formsSelect').value;
      const tbody = $('#fieldsTable tbody'); tbody.innerHTML = '';
      if(!cur){ tbody.innerHTML = `<tr><td colspan="12" class="text-center text-muted">Select or create a form.</td></tr>`; return; }
      const rows = settings.fields[cur]||[];

      rows.forEach((fld, i)=>{
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td class="text-muted"><i class="fa fa-grip-vertical"></i></td>
          <td><input class="form-control form-control-sm fld-name" value="${escapeHTML(fld.name||'')}"></td>
          <td><input class="form-control form-control-sm fld-label" value="${escapeHTML(fld.label||'')}"></td>
          <td>
            <select class="form-select form-select-sm fld-type">
              ${['text','password','email','number','date','tel'].map(t=>`<option value="${t}"${fld.type===t?' selected':''}>${t}</option>`).join('')}
            </select>
          </td>
          <td><input class="form-control form-control-sm fld-ph" value="${escapeHTML(fld.placeholder||'')}"></td>
          <td class="text-center"><input class="form-check-input fld-req" type="checkbox" ${fld.required?'checked':''}></td>
          <td><input class="form-control form-control-sm fld-pattern" value="${escapeHTML(fld.pattern||'')}"></td>
          <td style="width:80px"><input class="form-control form-control-sm fld-min" type="number" value="${escapeHTML(fld.min??'')}"></td>
          <td style="width:80px"><input class="form-control form-control-sm fld-max" type="number" value="${escapeHTML(fld.max??'')}"></td>
          <td><textarea class="form-control form-control-sm code fld-js" rows="2">${escapeHTML(fld.js||'')}</textarea></td>
          <td><textarea class="form-control form-control-sm code fld-css" rows="2">${escapeHTML(fld.css||'')}</textarea></td>
          <td>
            <div class="d-flex align-items-center gap-2">
              <div class="form-check">
                <input class="form-check-input fld-small" type="checkbox" ${fld.small?'checked':''} title="small row">
              </div>
              <button class="btn btn-sm btn-outline-danger"><i class="fa fa-trash"></i></button>
            </div>
          </td>
        `;
        tr.querySelector('.btn-outline-danger').onclick = async ()=>{ rows.splice(i,1); await saveSettings(); renderFieldsTable(); renderFormPreview($('#formsSelect').value); };
        const bind = (sel, prop, transform=(v)=>v)=> tr.querySelector(sel).onchange = async (e)=>{
          const val = (e.target.type==='checkbox') ? e.target.checked : e.target.value;
          fld[prop] = transform(val);
          await saveSettings();
          renderFormPreview($('#formsSelect').value);
        };
        bind('.fld-name','name');
        bind('.fld-label','label');
        bind('.fld-type','type');
        bind('.fld-ph','placeholder');
        bind('.fld-req','required');
        bind('.fld-pattern','pattern');
        bind('.fld-min','min');
        bind('.fld-max','max');
        bind('.fld-js','js', v=>v);
        bind('.fld-css','css', v=>v);
        bind('.fld-small','small');

        tbody.appendChild(tr);
      });

      new Sortable(tbody, {
        handle: '.fa-grip-vertical',
        animation: 150,
        onEnd: async ()=>{
          const newRows = [];
          tbody.querySelectorAll('tr').forEach(tr=>{
            newRows.push({
              name: tr.querySelector('.fld-name').value.trim(),
              label: tr.querySelector('.fld-label').value.trim(),
              type: tr.querySelector('.fld-type').value,
              placeholder: tr.querySelector('.fld-ph').value,
              required: tr.querySelector('.fld-req').checked,
              pattern: tr.querySelector('.fld-pattern').value,
              min: tr.querySelector('.fld-min').value,
              max: tr.querySelector('.fld-max').value,
              js: tr.querySelector('.fld-js').value,
              css: tr.querySelector('.fld-css').value,
              small: tr.querySelector('.fld-small').checked
            });
          });
          const cur = $('#formsSelect').value;
          settings.fields[cur] = newRows;
          await saveSettings();
          renderFormPreview(cur);
        }
      });
    }

    function renderFormsOrder(){
      const pg = settings.pages[currentPageIdx]; pg.forms_order ??= [];
      const allForms = Object.keys(settings.fields||{});
      const avail = $('#availableForms');
      avail.innerHTML = allForms.filter(f=>!pg.forms_order.includes(f))
        .map(f=>`<option value="${escapeHTML(f)}">${escapeHTML(f)}</option>`).join('');
      const ul = $('#pageFormsOrder'); ul.innerHTML='';
      pg.forms_order.forEach(name=>{
        const li = document.createElement('li');
        li.className = 'list-group-item d-flex justify-content-between align-items-center';
        li.innerHTML = `
          <span><i class="fa fa-grip-vertical me-2 text-muted"></i><span class="badge text-bg-primary">${escapeHTML(name)}</span></span>
          <button class="btn btn-sm btn-outline-danger"><i class="fa fa-trash"></i></button>`;
        li.querySelector('button').onclick = async ()=>{
          pg.forms_order = pg.forms_order.filter(x=>x!==name);
          if(pg.forms_submit) delete pg.forms_submit[name];
          await saveSettings(); renderFormsOrder(); renderFormsSubmit();
        };
        ul.appendChild(li);
      });
      new Sortable(ul,{handle:'.fa-grip-vertical', animation:150, onEnd: async ()=>{
        pg.forms_order = Array.from(ul.querySelectorAll('.badge')).map(b=>b.textContent.trim());
        await saveSettings(); renderFormsSubmit();
      }});

      avail.onchange = null;
      avail.ondblclick = async (e)=>{
        const val = e.target.value; if(!val) return;
        pg.forms_order.push(val);
        await saveSettings(); renderFormsOrder(); renderFormsSubmit();
      };
    }

    function renderFormsSubmit(){
      const pg = settings.pages[currentPageIdx]; pg.forms_submit ??= {};
      const wrap = $('#formsSubmitWrap'); wrap.innerHTML='';
      if(!pg.forms_order.length){
        wrap.innerHTML = `<div class="text-muted">No forms in this page. Go to <b>Fields</b> tab and add some.</div>`;
        return;
      }
      pg.forms_order.forEach(form=>{
        const conf = pg.forms_submit[form] || {label:'Submit', js:'', css:'', next_page:'', send_telegram:false};
        const box = document.createElement('div');
        box.className = 'border rounded p-3 mb-3';
        box.innerHTML = `
          <div class="d-flex align-items-center justify-content-between mb-2">
            <h6 class="m-0">Form: <span class="badge text-bg-info">${escapeHTML(form)}</span></h6>
          </div>
          <div class="row g-3">
            <div class="col-md-3">
              <label class="form-label">Button Label</label>
              <input class="form-control" id="fs_${cssID(form)}_label" value="${escapeHTML(conf.label||'Submit')}">
            </div>
            <div class="col-md-9">
              <label class="form-label">Custom JS (on submit)</label>
              <textarea class="form-control code" id="fs_${cssID(form)}_js" rows="3">${escapeHTML(conf.js||'')}</textarea>
            </div>
            <div class="col-md-6">
              <label class="form-label">Custom CSS (button)</label>
              <textarea class="form-control code" id="fs_${cssID(form)}_css" rows="3">${escapeHTML(conf.css||'')}</textarea>
              <div class="mini mt-1">Inline style applied on the button at runtime.</div>
            </div>
            <div class="col-md-4">
              <label class="form-label">Next Page</label>
              <select class="form-select" id="fs_${cssID(form)}_next">
                <option value="">(stay)</option>
                ${(settings.pages||[]).map(p=>`<option value="${escapeHTML(p.php)}"${conf.next_page===p.php?' selected':''}>${escapeHTML(p.display||p.php)}</option>`).join('')}
              </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" id="fs_${cssID(form)}_tg" ${conf.send_telegram?'checked':''}>
                <label class="form-check-label">Telegram</label>
              </div>
            </div>
          </div>
        `;
        wrap.appendChild(box);
      });
    }

    /************** LIVE PREVIEW (Generic) **************/
    function renderFormPreview(formName){
      const host = $('#formPreview');
      host.innerHTML = '';
      if(!formName || !(settings.fields?.[formName]) || !settings.fields[formName].length){
        host.innerHTML = `<div class="text-muted">No fields to preview.</div>`;
        return;
      }
      const fields = settings.fields[formName];

      // نجمع الحقول small في صفوف مزدوجة
      let bufferRow = [];
      const appendRow = ()=>{
        if(bufferRow.length){
          const row = document.createElement('div');
          row.className = 'row-fields';
          row.innerHTML = bufferRow.join('');
          host.appendChild(row);
          bufferRow = [];
        }
      };

      fields.forEach((fld, idx)=>{
        const name = escapeHTML(fld.name || ('field_'+idx));
        const label = escapeHTML(fld.label || name);
        const type = escapeHTML(fld.type || 'text');
        const placeholder = escapeHTML(fld.placeholder || '');
        const required = fld.required ? 'required' : '';
        const pattern = fld.pattern ? `pattern="${escapeHTML(fld.pattern)}"` : '';
        const min = fld.min ? `min="${escapeHTML(fld.min)}"` : '';
        const max = fld.max ? `max="${escapeHTML(fld.max)}"` : '';
        const css = fld.css ? `style="${escapeHTML(fld.css).replace(/"/g,'&quot;')}"` : '';

        const input = `<input ${css} class="preview-input" type="${type}" id="prev_${name}" placeholder="${placeholder}" ${required} ${pattern} ${min} ${max} autocomplete="off">`;
        const block = `
          <div class="card-input${fld.small ? ' small' : ''}">
            <label class="card-input__label" for="prev_${name}">
              ${label}${fld.required? ' <span style="color:#e00">*</span>':''}
            </label>
            ${input}
          </div>
        `;

        if(fld.small){
          bufferRow.push(block);
          // إذا اللي بعده مش small أو آخر عنصر — اقفل الصف
          const next = fields[idx+1];
          if(!next || !next.small){ appendRow(); }
        } else {
          appendRow();
          const wrapper = document.createElement('div');
          wrapper.innerHTML = block;
          host.appendChild(wrapper.firstElementChild);
        }
      });

      appendRow();

      // JS بسيط للمعاينة (على input) لو fld.js موجود
      fields.forEach((fld, idx)=>{
        if(!fld?.js) return;
        const name = escapeHTML(fld.name || ('field_'+idx));
        const el = document.getElementById('prev_'+name);
        if(!el) return;
        try{
          el.addEventListener('input', function(){
            try{ (new Function(fld.js)).call(this); }catch(e){}
          });
        }catch(_){}
      });
    }

    /**************** SAVE ALL **********************/
    async function saveAll(){
      if(!settings.pages.length){ toast('Nothing to save', 'warning'); return; }
      const pg = settings.pages[currentPageIdx];
      const cur = $('#formsSelect').value;
      if(cur){
        const tbody = $('#fieldsTable tbody');
        const newRows = [];
        tbody.querySelectorAll('tr').forEach(tr=>{
          if(!tr.querySelector('.fld-name')) return;
          newRows.push({
            name: tr.querySelector('.fld-name').value.trim(),
            label: tr.querySelector('.fld-label').value.trim(),
            type: tr.querySelector('.fld-type').value,
            placeholder: tr.querySelector('.fld-ph').value,
            required: tr.querySelector('.fld-req').checked,
            pattern: tr.querySelector('.fld-pattern').value.trim(),
            min: tr.querySelector('.fld-min').value,
            max: tr.querySelector('.fld-max').value,
            js: tr.querySelector('.fld-js').value,
            css: tr.querySelector('.fld-css').value,
            small: tr.querySelector('.fld-small').checked
          });
        });
        settings.fields[cur] = newRows;
      }
      const ul = $('#pageFormsOrder');
      pg.forms_order = Array.from(ul.querySelectorAll('.badge')).map(b=>b.textContent.trim());
      pg.forms_submit = pg.forms_submit || {};
      pg.forms_order.forEach(form=>{
        pg.forms_submit[form] = {
          label: $('#fs_'+cssID(form)+'_label')?.value || 'Submit',
          js: $('#fs_'+cssID(form)+'_js')?.value || '',
          css: $('#fs_'+cssID(form)+'_css')?.value || '',
          next_page: $('#fs_'+cssID(form)+'_next')?.value || '',
          send_telegram: $('#fs_'+cssID(form)+'_tg')?.checked || false
        };
      });
      pg.display = $('#pageTitle').value.trim();
      pg.html = $('#pageHtml').value;
      await saveSettings();
      await savePageFile(pg.php, pg.html);
      buildPagesSidebar();
      toast('Saved!');
    }
  </script>
</body>
</html>